SET client_encoding TO 'UTF8'; -- ??? >>  https://stackoverflow.com/questions/38481829/postgresql-character-with-byte-sequence-0xc2-0x81-in-encoding-utf8-has-no-equ

/*  Berechnung eines Korrekturfaktos für die leistbare Arbeit einer gegebenen Ressource und in einem gegebenen Zeitfensters.

    Der Korrekturfaktor beschreibt wieviele Arbeitseinheiten pro Zeiteinheit bearbeitet werden können.
    Ein KF von "1" heißt, das eine Zeiteinheit (eine Stunde auf dem Zeitstrahl) auch eine Arbeitsstunde abarbeitet.
    Also leistbare Arbeit im gegebenen Zeitfenster. zB 8 Stunden in 08-20 Uhr = 8 Stunden Arbeit in 10 Stunden Fenster = 0,8:
    Somit würde ein AG mit 8 Stunden benötigter Arbeitszeit 10 Stunden dauer im Timeslot erfordern.

    Dieser Gesamtkorrekturfaktor berechnet sich per Multiplikation der beiden folgenden Faktoren:
    1. Korrekturfaktor für die den Geschwindigkeit des Arbeitsplatzes (Spalte "scheduling.resource.ta_kf" bzw.
      "ksbva.ksb_ks_ba")
    2. Korrekturfaktor für das Verhältnis von Kostenstellentageskapazität und Arbeitszeitfenster der Kostenstelle

    Bei einer Auswärtskostenstelle oder wenn kein Korrekturfaktor berechnet werden kann, wird ein Faktor von 1 angenommen.
*/
SELECT tsystem.function__drop_by_regex( 'resource_timeline__timeslots_ta_kf__calc', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.resource_timeline__timeslots_ta_kf__calc(
    IN _timeframe_start timestamp,
    IN _timeframe_end timestamp,
    IN _resource_id integer = null,
    IN _ks_abt varchar = null,
    IN _ks_ba_num int = null
    )
    RETURNS TABLE (
      slotStartDate timestamp,
      slotEndDate   timestamp,
      ta_kf         numeric
    ) AS $$
    DECLARE

        _ksv_working_duration numeric; -- describes the workinghours of the KSV , example: 8oo till 18oo;
        _ksv_ba_kapa          numeric;
        _ks_ba_string         varchar = '';
        _ks_factor            numeric = 1;
        _timestart            time;
        _timeend              time;

    BEGIN

        -- shim old stuff into resource handling
        IF ( _resource_id IS NOT NULL ) THEN

            SELECT ksb_ks_abt, ksb_ks_ba_num, ksb_timestart, ksb_timeend
              INTO _ks_abt,   _ks_ba_num,     _timestart,    _timeend
              FROM ksvba b
              JOIN scheduling.resource r ON r.context_id = b.ksb_id AND r.context = 'ksvba'
             WHERE id = _resource_id;

        END IF;

        -- if ksv is ausw we always return 1
        IF ( SELECT ks_ausw FROM ksv WHERE ks_abt = _ks_abt ) THEN

            RETURN QUERY SELECT
                          _timeframe_start,
                          _timeframe_end,
                          _ks_factor
            ;

            -- ಠ_ಠ
            -- dafuq? was is das denn?
            -- https://stackoverflow.com/questions/8707978/in-plpgsql-how-to-exit-from-a-function-returning-records
            -- Die Doku erklärt das noch explizierter: https://www.postgresql.org/docs/13/plpgsql-control-structures.html#id-1.8.8.8.3.4
            -- RETURN QUERY geht nicht aus der funktion, dazu bedarf es nem »leeren« RETURN
            -- (╯°□°）╯︵ ┻━┻
            RETURN;

        END IF;

        -- translate ksv data to old style
        _ks_ba_string := _ks_abt;

        IF ( _ks_ba_num > 1 ) THEN
            _ks_ba_string := _ks_ba_string || ' /' || _ks_ba_num::VARCHAR;
        END IF;




        IF (
                _timeframe_start::date <> _timeframe_end
            AND _timeframe_start::date <> tsystem.date__extract_end_date( _timeframe_end )
        ) THEN

            RAISE EXCEPTION
              'tplanterm.ks_day_kapa(%) only works on one given date, not a range bigger than one day. given range is: % ~> %. CHECK OFF TIMES (resource_timeline__renew_offtime)',
              _ks_ba_string,
              _timeframe_start,
              _timeframe_end;
              -- TODO: wenn wir weit in der Zukunft liegen, einfach die Stammdaten annehmen? Eigentlich auch nicht sinnvoll, da RenewOfftimes nun auch nicht das Problem und klarere Datenstruktur?
        END IF;

        -- Bei Änderung F2-Fenste in Plantafel in Resource beachten. Suche nache resource_timeline__timeslots_ta_kf__calc in F2-Fenstern!
        _ksv_working_duration :=  extract(epoch FROM (_timeend - _timestart));
        _ksv_ba_kapa          :=  tplanterm.ks_day_kapa( _ks_abt, _ks_ba_string , _timeframe_start::date, false);

        -- raise notice 'ks_day_kapa: %, %, %', _timeframe_start::date,_ks_abt, _ks_ba_string;
        -- Korrekturfaktor = Kostenstellentageskapazität * 3600s / Arbeitszeitfenster der Kostenstelle
        _ks_factor := _ksv_ba_kapa * 3600 / _ksv_working_duration;

        -- if nothing is found, we assume 1
        IF ( _ks_factor IS NULL ) THEN
            _ks_factor := 1;
        END IF;

        -- this should return 1 if no other values are available
        RETURN QUERY
          SELECT _timeframe_start, _timeframe_end, _ks_factor;

    END $$ LANGUAGE plpgsql STABLE;
